/* inspired by http://glsl.heroku.com/e#5254.1 */

uniform float time;
uniform float alpha;
uniform vec2 resolution;
uniform vec2 flarepos;
uniform float flaresize;

#define COLOUR vec3(0.95, 0.65, 0.30)

vec4 plasma(void)
{
	float x = gl_FragCoord.x+sin(time/30.)*resolution.x*sin(cos(time/10.)/3.)*10.;
	float y = gl_FragCoord.y+cos(time/20.)*resolution.y*sin(sin(time/14.)/4.)*14.;
	float rm = cos(y/200.)+sin(x/290.)+cos(time+y/240.);
	float bm = cos(y/210.)+sin(x/300.)+cos(time+y/220.);
	float r = abs(rm*0.3);
	float g = 0.;
	float b = abs(bm*0.3);
	return vec4(r,g,b,alpha);
}

vec4 flare(void)
{
	vec2 actualpos = flarepos.xy / resolution.xy;
	vec2 position = (( gl_FragCoord.xy / resolution.xy ) - vec2(0.5)) / vec2(resolution.y/resolution.x,1.0);
	float c = clamp(sin(time*2.+atan(position.y - actualpos.y, position.x - actualpos.x)*7.), 0.0, 1.0);
	
	vec3 col = (COLOUR / distance(actualpos, position)) * flaresize;
	col += COLOUR * min(1.0, c * 0.7) * (1.0 / distance(actualpos, position) * 0.2);
	return vec4(col, alpha);
}

void main(void)
{
	vec4 p = plasma();
	vec4 f = flare();
	gl_FragColor = p+f;
}




